{{-- resources/views/components/dynamic-input.blade.php --}}
<div class="dynamic-input-wrapper"
     data-input-name="{{ $name }}"
     data-placeholder="{{ $placeholder }}"
     data-input-type="{{ $inputType }}"
     data-column-class="{{ $columnClass }}"
     data-required="{{ $required }}">
    <div class="mb-4">
        <div class="justify-content-between">
            <div class="form-group">
                <a href="javascript:void(0)" class="btn btn-success float-left mt-3 add-item">
                    <i class="fa fa-{{ $icon }}"></i> {{ $buttonText }}
                </a>
            </div>
            <div class="row items-container mt-3 col-md-10">
                @foreach($items as $item)
                    <div class="{{ $columnClass }} pb-2 dynamic-input-group">
                        <div class="form-group">
                            <div class="input-group">
                                <input name="{{ $name }}[]"
                                       class="form-control"
                                       type="{{ $inputType }}"
                                       value="{{ $item }}"
                                       {{ $required ? 'required' : '' }}
                                       placeholder="{{ $placeholder }}">
                                <span class="input-group-btn">
                                    <button class="btn btn-white delete-item" type="button">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

@once
    @push('script')
    <script>
    $(document).ready(function() {
        function initDynamicInput(wrapper) {
            const $wrapper = $(wrapper);
            const inputName = $wrapper.data('input-name');
            const placeholder = $wrapper.data('placeholder');
            const inputType = $wrapper.data('input-type');
            const columnClass = $wrapper.data('column-class');
            const required = $wrapper.data('required');

            // Add new item
            $wrapper.find('.add-item').click(function() {
                const newInput = `
                    <div class="${columnClass} pb-2 dynamic-input-group">
                        <div class="form-group">
                            <div class="input-group">
                                <input name="${inputName}[]"
                                       class="form-control"
                                       type="${inputType}"
                                       ${required ? 'required' : ''}
                                       placeholder="${placeholder}">
                                <span class="input-group-btn">
                                    <button class="btn btn-white delete-item" type="button">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                `;
                $wrapper.find('.items-container').append(newInput);
            });

            // Delete item
            $wrapper.on('click', '.delete-item', function() {
                $(this).closest('.dynamic-input-group').remove();
            });
        }

        // Initialize all dynamic input components on the page
        $('.dynamic-input-wrapper').each(function() {
            initDynamicInput(this);
        });
    });
    </script>
    @endpush
@endonce
